/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.ExtKeyEventProcessor;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.TabbedPanePainter;
import de.javasoft.util.JavaVersion;
import de.javasoft.util.java2d.DropShadow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;

public class GraphicsUtils
extends SynthGraphicsUtils {
    public void paintText(SynthContext synthContext, Graphics graphics, String string, int n2, int n3, int n4) {
        Object object;
        Object object2;
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        if (region == Region.BUTTON || region == Region.TOGGLE_BUTTON) {
            if (!SyntheticaLookAndFeel.getBoolean("Button.showMnemonics", jComponent, true)) {
                n4 = -1;
            }
            if ((object2 = (String)SyntheticaLookAndFeel.get("Synthetica.button.textBackground", jComponent)) != null && ((String)object2).length() > 0 && string != null && string.trim().length() > 0) {
                Object object3 = object = (Insets)SyntheticaLookAndFeel.get("Synthetica.button.textBackground.insets", jComponent);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n5 = fontMetrics.getHeight();
                int n6 = fontMetrics.stringWidth(string);
                ImagePainter imagePainter = new ImagePainter(graphics, n2 - 2, n3, n6 + 4, n5, (String)object2, (Insets)object, (Insets)object3, 0, 0);
                imagePainter.draw();
            }
        } else if (region == Region.TABBED_PANE_TAB) {
            TabbedPanePainter tabbedPanePainter;
            Object object4;
            Color color;
            object2 = (JTabbedPane)jComponent;
            int n7 = ((JTabbedPane)object2).getSelectedIndex();
            int n8 = SyntheticaLookAndFeel.getClientProperty("Synthetica.tabbedPane.tabIndex", (JComponent)object2, -1);
            Color color2 = color = n8 >= 0 ? ((JTabbedPane)object2).getForegroundAt(n8) : null;
            if (color != null && !(color instanceof UIResource)) {
                graphics.setColor(color);
            }
            if (n7 != n8 && SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.bold", (Component)object2)) {
                int n9 = graphics.getFontMetrics().stringWidth(string);
                graphics.setFont(graphics.getFont().deriveFont(0));
                int n10 = graphics.getFontMetrics().stringWidth(string);
                n2 += (n9 - n10) / 2;
            }
            if ((object4 = SyntheticaLookAndFeel.get("Synthetica.TabbedPanePainter", jComponent)) instanceof TabbedPanePainter && !(tabbedPanePainter = (TabbedPanePainter)object4).paintTabbedPaneTabText(synthContext, graphics, string, n2, n3, n4)) {
                return;
            }
        } else if (region == Region.PROGRESS_BAR) {
            object2 = (String)SyntheticaLookAndFeel.get("Synthetica.progressBar.textBackground", jComponent);
            if (object2 != null && ((String)object2).length() > 0 && string != null && string.trim().length() > 0) {
                Object object5 = object = (Insets)SyntheticaLookAndFeel.get("Synthetica.progressBar.textBackground.insets", jComponent);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n11 = fontMetrics.getHeight();
                int n12 = fontMetrics.stringWidth(string);
                ImagePainter imagePainter = new ImagePainter(graphics, n2 - 2, n3, n12 + 4, n11, (String)object2, (Insets)object, (Insets)object5, 0, 0);
                imagePainter.draw();
            }
        } else if (region == Region.INTERNAL_FRAME_TITLE_PANE) {
            if (!JavaVersion.JAVA5 && n4 == -1) {
                return;
            }
        } else if (!(region != Region.MENU && region != Region.MENU_ITEM && region != Region.CHECK_BOX_MENU_ITEM && region != Region.RADIO_BUTTON_MENU_ITEM || this.getPaintMnemonics())) {
            n4 = -1;
        } else if (region == Region.MENU_ITEM_ACCELERATOR && UIManager.get("MenuItem.acceleratorDelimiter") != null) {
            string = string.replace("+", UIManager.getString("MenuItem.acceleratorDelimiter"));
        }
        if (SyntheticaLookAndFeel.getAntiAliasEnabled() || SyntheticaLookAndFeel.getBoolean("Synthetica.text.antialias", jComponent)) {
            object2 = (Graphics2D)graphics;
            object = ((Graphics2D)object2).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (JavaVersion.JAVA5) {
                ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            }
            super.paintText(synthContext, (Graphics)object2, string, n2, n3, n4);
            ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            super.paintText(synthContext, graphics, string, n2, n3, n4);
        }
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, Icon icon, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (SyntheticaLookAndFeel.getAntiAliasEnabled() || SyntheticaLookAndFeel.getBoolean("Synthetica.text.antialias", synthContext.getComponent())) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (JavaVersion.JAVA5) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            }
            super.paintText(synthContext, graphics2D, string, icon, n2, n3, n4, n5, n6, n7, n8);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            super.paintText(synthContext, graphics, string, icon, n2, n3, n4, n5, n6, n7, n8);
        }
    }

    protected boolean getPaintMnemonics() {
        if (ExtKeyEventProcessor.showMnemonicsOnAltKeyOnly()) {
            return ExtKeyEventProcessor.isMenuActive();
        }
        return true;
    }

    public void drawLine(SynthContext synthContext, Object object, Graphics graphics, int n2, int n3, int n4, int n5) {
        JComponent jComponent = synthContext.getComponent();
        if (object instanceof String && ((String)object).startsWith("Tree.")) {
            String string;
            Color color = null;
            if (object.equals("Tree.horizontalLine")) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.tree.line.color.horizontal", jComponent);
            } else if (object.equals("Tree.verticalLine")) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.tree.line.color.vertical", jComponent);
            }
            if (color != null) {
                graphics.setColor(color);
            }
            if ("SOLID".equals(string = SyntheticaLookAndFeel.getString("Synthetica.tree.line.type", jComponent))) {
                graphics.drawLine(n2, n3, n4, n5);
            } else if ("DASHED".equals(string)) {
                int n6;
                int n7 = SyntheticaLookAndFeel.getInt("Synthetica.tree.line.dashed.line", jComponent);
                if (n7 <= 0) {
                    n7 = 2;
                }
                if ((n6 = SyntheticaLookAndFeel.getInt("Synthetica.tree.line.dashed.space", jComponent)) <= 0) {
                    n6 = 1;
                }
                if (object.equals("Tree.horizontalLine")) {
                    int n8 = n2;
                    while (n8 < n4) {
                        graphics.drawLine(n8, n3, Math.min(n8 + n7 - 1, n4), n5);
                        n8 += n7 + n6;
                    }
                } else {
                    int n9 = n3;
                    while (n9 < n5) {
                        graphics.drawLine(n2, n9, n2, Math.min(n9 + n7 - 1, n5));
                        n9 += n7 + n6;
                    }
                }
            }
            return;
        }
        if (n2 == n4 && object instanceof String && ((String)object).equals("Table.grid") && SyntheticaLookAndFeel.getInt("Synthetica.table.columnMargin", synthContext.getComponent(), 1) == 0) {
            return;
        }
        if (n3 == n5 && object instanceof String && ((String)object).equals("Table.grid") && SyntheticaLookAndFeel.getInt("Synthetica.table.rowMargin", synthContext.getComponent(), 1) == 0) {
            return;
        }
        super.drawLine(synthContext, object, graphics, n2, n3, n4, n5);
    }

    public String layoutText(SynthContext synthContext, FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        Object object;
        JComponent jComponent = synthContext.getComponent();
        if (jComponent instanceof JTabbedPane) {
            n4 = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.text.position.leading", jComponent) ? 10 : 11;
            object = SyntheticaLookAndFeel.getStyleFactory();
            SynthStyle synthStyle = ((SynthStyleFactory)object).getStyle(synthContext.getComponent(), Region.TABBED_PANE);
            if (synthStyle.get(synthContext, "TabbedPane.textIconGap") == null) {
                n6 = 4;
            }
        }
        object = super.layoutText(synthContext, fontMetrics, string, icon, n2, n3, n4, n5, rectangle, rectangle2, rectangle3, n6);
        if (jComponent instanceof JTabbedPane && ((JTabbedPane)jComponent).getTabCount() > 0) {
            this.tabbedPaneTabCorrection(synthContext, (JTabbedPane)jComponent, fontMetrics, string, icon, rectangle, rectangle3, rectangle2);
        }
        return object;
    }

    private void tabbedPaneTabCorrection(SynthContext synthContext, JTabbedPane jTabbedPane, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n2;
        int n3 = jTabbedPane.getSelectedIndex();
        boolean bl = n3 == (n2 = SyntheticaLookAndFeel.getClientProperty("Synthetica.tabbedPane.tabIndex", jTabbedPane, -1).intValue());
        int n4 = jTabbedPane.getTabPlacement();
        if (n2 >= 0 && jTabbedPane.getIconAt(n2) != null) {
            int n5 = fontMetrics.getHeight();
            int n6 = Math.max(n5, jTabbedPane.getIconAt(n2).getIconHeight());
            rectangle2.y += (n5 - n6) / 2;
        }
        String string2 = "tabbedPane.tab";
        if (bl) {
            string2 = String.valueOf(string2) + ".selected";
        }
        if (n4 == 1) {
            string2 = String.valueOf(string2) + ".top";
        } else if (n4 == 2) {
            string2 = String.valueOf(string2) + ".left";
        } else if (n4 == 3) {
            string2 = String.valueOf(string2) + ".bottom";
        } else if (n4 == 4) {
            string2 = String.valueOf(string2) + ".right";
        }
        String string3 = SyntheticaLookAndFeel.getStyleName(jTabbedPane);
        Insets insets = SyntheticaLookAndFeel.getInsets(string2, "text.insets", string3, true);
        if (insets != null) {
            rectangle2.x += insets.left;
            switch (jTabbedPane.getTabPlacement()) {
                case 1: {
                    rectangle2.y += insets.top;
                    break;
                }
                case 3: {
                    rectangle2.y -= insets.bottom;
                }
            }
        }
        if (icon != null) {
            insets = SyntheticaLookAndFeel.getInsets(string2, "icon.insets", string3, true);
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            rectangle3.x += insets.left;
            if (jTabbedPane.getTabPlacement() == 1) {
                rectangle3.y += insets.top;
            } else if (jTabbedPane.getTabPlacement() == 3) {
                rectangle3.y -= insets.bottom;
            }
        }
    }

    public static Image iconToImage(SynthContext synthContext, Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        JComponent jComponent = synthContext == null ? null : synthContext.getComponent();
        icon.paintIcon(jComponent, graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }

    public void paintListCellRendererSelectionBackground(JList jList, Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        boolean bl = this.cellRendererRespectsFocus(component) ? jList.hasFocus() : true;
        String string = SyntheticaLookAndFeel.getString(bl ? "Synthetica.list.selectionBackground" : "Synthetica.list.selectionBackground.inactive", component);
        if (string != null) {
            Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.list.selectionBackground.insets", component, false);
            ImagePainter imagePainter = new ImagePainter(graphics, n2, n3, n4, n5, string, insets, insets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintTreeCellRendererSelectionBackground(JTree jTree, Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        String string;
        boolean bl = true;
        if (this.cellRendererRespectsFocus(component)) {
            bl = jTree.getParent() instanceof CellRendererPane ? jTree.getParent().getParent().hasFocus() : jTree.hasFocus();
        }
        if ((string = SyntheticaLookAndFeel.getString(bl ? "Synthetica.tree.selectionBackground" : "Synthetica.tree.selectionBackground.inactive", component)) != null) {
            Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.tree.selectionBackground.insets", component, false);
            ImagePainter imagePainter = new ImagePainter(graphics, n2, n3, n4, n5, string, insets, insets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintTableCellRendererSelectionBackground(JTable jTable, Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        String string;
        boolean bl;
        boolean bl2 = bl = this.cellRendererRespectsFocus(component) ? jTable.hasFocus() : true;
        if (jTable.getCellEditor() != null) {
            bl = true;
        }
        if ((string = SyntheticaLookAndFeel.getString(bl ? "Synthetica.table.selectionBackground" : "Synthetica.table.selectionBackground.inactive", component)) != null) {
            Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.table.selectionBackground.insets", component, false);
            ImagePainter imagePainter = new ImagePainter(graphics, n2, n3, n4, n5, string, insets, insets, 0, 0);
            imagePainter.draw();
        }
    }

    private boolean cellRendererRespectsFocus(Component component) {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.cellRenderer.respectFocus", component, false);
    }

    protected void paintTextShadow(JComponent jComponent, Graphics graphics, int n2, int n3, String string, boolean bl, int n4, int n5, float f2, Color color, int n6, int n7, boolean bl2, int n8) {
        if (string == null || string.length() == 0) {
            return;
        }
        Font font = bl2 ? graphics.getFont() : jComponent.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n9 = fontMetrics.stringWidth(string);
        int n10 = fontMetrics.getHeight() + n4 * 2;
        BufferedImage bufferedImage = this.createCompatibleImage(n9, n10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(font);
        ((Graphics)graphics2D).drawString(string, 0, fontMetrics.getAscent());
        if (this.getPaintMnemonics() && n8 >= 0 && n8 < string.length()) {
            int n11 = fontMetrics.stringWidth(string.substring(0, n8));
            int n12 = fontMetrics.getHeight() - 1;
            int n13 = fontMetrics.charWidth(string.charAt(n8));
            graphics2D.fillRect(n11, n12, n13, 1);
        }
        graphics2D.dispose();
        DropShadow dropShadow = new DropShadow(bufferedImage);
        dropShadow.setQuality(bl);
        dropShadow.setShadowSize(n4);
        dropShadow.setDistance(n5);
        dropShadow.setShadowOpacity(f2);
        dropShadow.setShadowColor(color);
        dropShadow.paintShadow(graphics, n2 + n6, n3 + n7);
    }

    private BufferedImage createCompatibleImage(int n2, int n3) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        return graphicsConfiguration.createCompatibleImage(n2, n3, 3);
    }
}

